//**************************************************************************/
// Copyright (c) 2011 Autodesk, Inc.
// All rights reserved.
// 
// These coded instructions, statements, and computer programs contain
// unpublished proprietary information written by Autodesk, Inc., and are
// protected by Federal copyright law. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without
// the prior written consent of Autodesk, Inc.
//**************************************************************************/
// DESCRIPTION: PointCloud simple rendering effect.
// AUTHOR: Danny Chen
// CREATED: April 2012
//**************************************************************************/

float gPointSize = 1.0f; // point size constant
float2 gPixelSize; //Inverse screen size

float4x4 gWVPXf : WorldViewProjection < string UIWidget = "None"; >; // transform matrix

struct VS_INPUT
{
    float3 Pos  : POSITION;	
	float3 Normal : NORMAL;
	float4 Color   : COLOR;
	float2 Layer : TEXCOORD0;
}; 

struct VS_TO_PS
{
    float4 HPos       : POSITION;
	float4 Color	  : TEXCOORD0;
};

VS_TO_PS SimplePointCloud_VS(VS_INPUT In)
{

	VS_TO_PS output;
	output.HPos = mul(float4(In.Pos,1.0f),gWVPXf);
	output.Color = In.Color;
	
	return output;
}

float4 SimplePointCloud_PS(VS_TO_PS In): COLOR
{
	return float4(In.Color.xyz,1.0f);
}

// Simply output point color.
technique RenderPoint
{
    pass P0
    {          
        VertexShader = compile vs_2_0 SimplePointCloud_VS();
        PixelShader  = compile ps_2_0 SimplePointCloud_PS(); 
    }
}